#ifndef __fxlc95xxx_i2c_h__
#define __fxlc95xxx_i2c_h__ 1
/**HEADER********************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: fxlc95xxx_i2c.h$
* $Version : 1.0.0.0$
* $Date    : Nov-11-2011$
*
* Comments:
*
*   This file contains the type definitions for the I2C module of the
*   fxlc95xxx Coldfire family.
*
*END************************************************************************/


#define __fxlc95xxx_i2c_h__version "$Version:1.0.0.0$"
#define __fxlc95xxx_i2c_h__date    "$Date:Nov-11-2011$"


#define FXLC95XXX_IICA_AD1_MASK              (0x02)
#define FXLC95XXX_IICA_AD2_MASK              (0x04)
#define FXLC95XXX_IICA_AD3_MASK              (0x08)
#define FXLC95XXX_IICA_AD4_MASK              (0x10)
#define FXLC95XXX_IICA_AD5_MASK              (0x20)
#define FXLC95XXX_IICA_AD6_MASK              (0x40)
#define FXLC95XXX_IICA_AD7_MASK              (0x80)
#define FXLC95XXX_IICA_AD_1_MASK             (0xFE)
#define FXLC95XXX_IICA_AD_1_BITNUM           (0x01)

#define FXLC95XXX_IICF_ICR0_MASK             (0x01)
#define FXLC95XXX_IICF_ICR1_MASK             (0x02)
#define FXLC95XXX_IICF_ICR2_MASK             (0x04)
#define FXLC95XXX_IICF_ICR3_MASK             (0x08)
#define FXLC95XXX_IICF_ICR4_MASK             (0x10)
#define FXLC95XXX_IICF_ICR5_MASK             (0x20)
#define FXLC95XXX_IICF_MULT0_MASK            (0x40)
#define FXLC95XXX_IICF_MULT1_MASK            (0x80)
#define FXLC95XXX_IICF_ICR_MASK              (0x3F)
#define FXLC95XXX_IICF_ICR_BITNUM            (0x00)
#define FXLC95XXX_IICF_MULT_MASK             (0xC0)
#define FXLC95XXX_IICF_MULT_BITNUM           (0x06)
#define FXLC95XXX_IICF_SET(mult,icr)         ( (((mult)<<FXLC95XXX_IICF_MULT_BITNUM)&FXLC95XXX_IICF_MULT_MASK) \
                                           | (((icr)<<FXLC95XXX_IICF_ICR_BITNUM)&FXLC95XXX_IICF_ICR_MASK) )

#define FXLC95XXX_IIC_MUL_1                  (0x01)
#define FXLC95XXX_IIC_MUL_2                  (0x02)
#define FXLC95XXX_IIC_MUL_4                  (0x04)
                                          
#define FXLC95XXX_IIC_IICF_MUL_1             (0x00)
#define FXLC95XXX_IIC_IICF_MUL_2             (0x01)
#define FXLC95XXX_IIC_IICF_MUL_4             (0x03)

#define FXLC95XXX_IICC1_RSTA_MASK            (0x04)
#define FXLC95XXX_IICC1_TXAK_MASK            (0x08)
#define FXLC95XXX_IICC1_TX_MASK              (0x10)
#define FXLC95XXX_IICC1_MST_MASK             (0x20)
#define FXLC95XXX_IICC1_IICIE_MASK           (0x40)
#define FXLC95XXX_IICC1_IICEN_MASK           (0x80)

#define FXLC95XXX_IICS_RXAK_MASK             (0x01)
#define FXLC95XXX_IICS_IICIF_MASK            (0x02)
#define FXLC95XXX_IICS_SRW_MASK              (0x04)
#define FXLC95XXX_IICS_ARBL_MASK             (0x10)
#define FXLC95XXX_IICS_BUSY_MASK             (0x20)
#define FXLC95XXX_IICS_IAAS_MASK             (0x40)
#define FXLC95XXX_IICS_TCF_MASK              (0x80)

#define FXLC95XXX_IICD_DATA0_MASK            (0x01)
#define FXLC95XXX_IICD_DATA1_MASK            (0x02)
#define FXLC95XXX_IICD_DATA2_MASK            (0x04)
#define FXLC95XXX_IICD_DATA3_MASK            (0x08)
#define FXLC95XXX_IICD_DATA4_MASK            (0x10)
#define FXLC95XXX_IICD_DATA5_MASK            (0x20)
#define FXLC95XXX_IICD_DATA6_MASK            (0x40)
#define FXLC95XXX_IICD_DATA7_MASK            (0x80)

#define FXLC95XXX_IICC2_AD8_MASK             (0x01)
#define FXLC95XXX_IICC2_AD9_MASK             (0x02)
#define FXLC95XXX_IICC2_AD10_MASK            (0x04)
#define FXLC95XXX_IICC2_ADEXT_MASK           (0x40)
#define FXLC95XXX_IICC2_GCAEN_MASK           (0x80)
#define FXLC95XXX_IICC2_AD_8_MASK            (0x07)
#define FXLC95XXX_IICC2_AD_8_BITNUM          (0x00)

#define FXLC95XXX_IICSMB_SHTF_MASK           (0x04)
#define FXLC95XXX_IICSMB_SLTF_MASK           (0x08)
#define FXLC95XXX_IICSMB_TCKSEL_MASK         (0x10)
#define FXLC95XXX_IICSMB_SIICAEN_MASK        (0x20)
#define FXLC95XXX_IICSMB_ALERTEN_MASK        (0x40)
#define FXLC95XXX_IICSMB_FACK_MASK           (0x80)

#define FXLC95XXX_IICA2_SAD1_MASK            (0x02)
#define FXLC95XXX_IICA2_SAD2_MASK            (0x04)
#define FXLC95XXX_IICA2_SAD3_MASK            (0x08)
#define FXLC95XXX_IICA2_SAD4_MASK            (0x10)
#define FXLC95XXX_IICA2_SAD5_MASK            (0x20)
#define FXLC95XXX_IICA2_SAD6_MASK            (0x40)
#define FXLC95XXX_IICA2_SAD7_MASK            (0x80)
#define FXLC95XXX_IICA2_SAD_1_MASK           (0xFE)
#define FXLC95XXX_IICA2_SAD_1_BITNUM         (0x01)

#define FXLC95XXX_IICSLTL_SSLT0_MASK         (0x01)
#define FXLC95XXX_IICSLTL_SSLT1_MASK         (0x02)
#define FXLC95XXX_IICSLTL_SSLT2_MASK         (0x04)
#define FXLC95XXX_IICSLTL_SSLT3_MASK         (0x08)
#define FXLC95XXX_IICSLTL_SSLT4_MASK         (0x10)
#define FXLC95XXX_IICSLTL_SSLT5_MASK         (0x20)
#define FXLC95XXX_IICSLTL_SSLT6_MASK         (0x40)
#define FXLC95XXX_IICSLTL_SSLT7_MASK         (0x80)

#define FXLC95XXX_IICSLTH_SSLT8_MASK         (0x01)
#define FXLC95XXX_IICSLTH_SSLT9_MASK         (0x02)
#define FXLC95XXX_IICSLTH_SSLT10_MASK        (0x04)
#define FXLC95XXX_IICSLTH_SSLT11_MASK        (0x08)
#define FXLC95XXX_IICSLTH_SSLT12_MASK        (0x10)
#define FXLC95XXX_IICSLTH_SSLT13_MASK        (0x20)
#define FXLC95XXX_IICSLTH_SSLT14_MASK        (0x40)
#define FXLC95XXX_IICSLTH_SSLT15_MASK        (0x80)

#define FXLC95XXX_IICSLT_SSLT0_MASK          (0x0001)
#define FXLC95XXX_IICSLT_SSLT1_MASK          (0x0002)
#define FXLC95XXX_IICSLT_SSLT2_MASK          (0x0004)
#define FXLC95XXX_IICSLT_SSLT3_MASK          (0x0008)
#define FXLC95XXX_IICSLT_SSLT4_MASK          (0x0010)
#define FXLC95XXX_IICSLT_SSLT5_MASK          (0x0020)
#define FXLC95XXX_IICSLT_SSLT6_MASK          (0x0040)
#define FXLC95XXX_IICSLT_SSLT7_MASK          (0x0080)
#define FXLC95XXX_IICSLT_SSLT8_MASK          (0x0100)
#define FXLC95XXX_IICSLT_SSLT9_MASK          (0x0200)
#define FXLC95XXX_IICSLT_SSLT10_MASK         (0x0400)
#define FXLC95XXX_IICSLT_SSLT11_MASK         (0x0800)
#define FXLC95XXX_IICSLT_SSLT12_MASK         (0x1000)
#define FXLC95XXX_IICSLT_SSLT13_MASK         (0x2000)
#define FXLC95XXX_IICSLT_SSLT14_MASK         (0x4000)
#define FXLC95XXX_IICSLT_SSLT15_MASK         (0x8000)

#define FXLC95XXX_IICFLT_FLT0_MASK           (0x01)
#define FXLC95XXX_IICFLT_FLT1_MASK           (0x02)
#define FXLC95XXX_IICFLT_FLT2_MASK           (0x04)
#define FXLC95XXX_IICFLT_FLT_MASK            (0x07)
#define FXLC95XXX_IICFLT_FLT_BITNUM          (0x00)

                          
#if (PSP_MQX_CPU_IS_FXLC95000) 
    #define I2C_SMB_SUPPORT     (0) //FALSE
#else
    #define I2C_SMB_SUPPORT     (1) //TRUE
#endif
/*------------------------------------------------------------------------*/
/*

/*
** FXLC95XXX_I2C_STRUCT
** This structure defines what one i2c register look like
*/


typedef struct fxlc95xxx_i2c_struct
{
   uchar  IIC_A1;   /*** IIC1A1 - IIC Address Register; 0xFFFF8200 ***/
   uchar  IIC_F;    /*** IIC1F - IIC Frequency Divider Register; 0xFFFF8201 ***/
   uchar  IIC_C1;   /*** IIC1C1 - IIC Control Register 1; 0xFFFF8202 ***/
   uchar  IIC_S;    /*** IIC1S - IIC Status Register; 0xFFFF8203 ***/
   uchar  IIC_D;    /*** IIC1D - IIC Data I/O Register; 0xFFFF8204 ***/
   uchar  IIC_C2;   /*** IIC1C2 - IIC Control Register 2; 0xFFFF8205 ***/
#if I2C_SMB_SUPPORT 
   uchar  IIC_SMB;  /*** IIC1SMB - SMBus Control and Status Register; 0xFFFF8206 ***/
   uchar  IIC_A2;   /*** IIC1A2 - IIC Address Register 2; 0xFFFF8207 ***/
   uchar  IIC_SLTH; /*** IIC1SLT - IIC SCL Low Time Out register; 0xFFFF8208 ***/
   uchar  IIC_SLTL; /*** IIC1SLTL - IIC SCL Low Time Out register - Low byte; 0xFFFF8209 ***/
   uchar  IIC_FLT;  /*** IIC1FLT - IIC Filter register; 0xFFFF820A ***/
#endif   
} FXLC95XXX_I2C_STRUCT, _PTR_ FXLC95XXX_I2C_STRUCT_PTR;
typedef volatile struct fxlc95xxx_i2c_struct _PTR_ VFXLC95XXX_I2C_STRUCT_PTR;





#endif

